<?php
require_once __DIR__ . '/../config/db.php';
$pdo = getDBConnection();

$stats = [
    'total_pins' => $pdo->query("SELECT COUNT(*) FROM pins")->fetchColumn(),
    'unposted_pins' => $pdo->query("SELECT COUNT(*) FROM pins WHERE pin_id IS NULL")->fetchColumn(),
    'posted_pins' => $pdo->query("SELECT COUNT(*) FROM pins WHERE pin_id IS NOT NULL")->fetchColumn(),
    'categories' => $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn(),
];

$categoryStats = $pdo->query("SELECT c.category_name, COUNT(p.id) as total, SUM(CASE WHEN p.pin_id IS NOT NULL THEN 1 ELSE 0 END) as posted FROM categories c LEFT JOIN pins p ON c.id = p.category_id GROUP BY c.id ORDER BY total DESC")->fetchAll();

// Query for ALL categories and their board template status
$freeBoards = $pdo->query("
    SELECT c.category_name, 
           SUM(CASE WHEN bd.bid IS NOT NULL AND ab.bid IS NULL THEN 1 ELSE 0 END) as unused_count,
           SUM(CASE WHEN ab.bid IS NOT NULL THEN 1 ELSE 0 END) as used_count,
           COUNT(bd.bid) as total_templates
    FROM categories c
    LEFT JOIN board_data bd ON c.id = bd.category_id
    LEFT JOIN account_board ab ON bd.bid = ab.bid
    GROUP BY c.id, c.category_name
    ORDER BY total_templates DESC, c.category_name ASC
")->fetchAll();

$page_title = 'Statistics - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <h1><i class="fas fa-chart-line"></i> Statistics & Analytics</h1>
</div>

<div class="stats-grid">
    <div class="stat-card">
        <i class="fas fa-thumbtack stat-icon"></i>
        <div class="stat-value"><?php echo $stats['total_pins']; ?></div>
        <div class="stat-label">Total Pins</div>
    </div>
    <div class="stat-card">
        <i class="fas fa-clock stat-icon"></i>
        <div class="stat-value"><?php echo $stats['unposted_pins']; ?></div>
        <div class="stat-label">Unposted</div>
    </div>
    <div class="stat-card">
        <i class="fas fa-check-circle stat-icon"></i>
        <div class="stat-value"><?php echo $stats['posted_pins']; ?></div>
        <div class="stat-label">Posted</div>
    </div>
    <div class="stat-card">
        <i class="fas fa-folder stat-icon"></i>
        <div class="stat-value"><?php echo $stats['categories']; ?></div>
        <div class="stat-label">Categories</div>
    </div>
</div>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 30px;">
    <div class="page-card" style="margin-bottom: 0;">
        <h2 style="margin-bottom: 20px;"><i class="fas fa-list-ul"></i> Pins by Category</h2>
        <div style="overflow-x: auto;">
            <table>
                <thead>
                    <tr>
                        <th>Category</th>
                        <th>Total</th>
                        <th>Posted</th>
                        <th>Progress</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categoryStats as $cat): 
                        $pct = $cat['total'] > 0 ? round(($cat['posted'] / $cat['total']) * 100) : 0;
                    ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($cat['category_name']); ?></strong></td>
                            <td><?php echo $cat['total']; ?></td>
                            <td><span class="badge badge-success"><?php echo $cat['posted']; ?></span></td>
                            <td>
                                <div style="width: 100%; min-width: 120px;">
                                    <div style="width: 100%; background: #edf2f7; height: 8px; border-radius: 4px; overflow: hidden; margin-bottom: 5px;">
                                        <div style="width: <?php echo $pct; ?>%; background: linear-gradient(90deg, var(--primary), var(--secondary)); height: 100%;"></div>
                                    </div>
                                    <small><?php echo $pct; ?>%</small>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="page-card" style="margin-bottom: 0;">
        <h2 style="margin-bottom: 20px;"><i class="fas fa-columns"></i> Board Template Status</h2>
        <p style="color: #718096; margin-bottom: 20px; font-size: 0.9em;">Overview of template usage across accounts.</p>
        <div style="overflow-x: auto;">
            <table>
                <thead>
                    <tr>
                        <th>Category</th>
                        <th>Total</th>
                        <th>Free</th>
                        <th>Usage</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($freeBoards as $fb): 
                        $pct = $fb['total_templates'] > 0 ? round(($fb['used_count'] / $fb['total_templates']) * 100) : 0;
                        $is_empty = $fb['total_templates'] == 0;
                        $is_depleted = !$is_empty && $fb['unused_count'] == 0;
                    ?>
                        <tr <?php echo ($is_empty || $is_depleted) ? 'style="background-color: #fff5f5;"' : ''; ?>>
                            <td>
                                <strong <?php echo ($is_empty || $is_depleted) ? 'style="color: #e53e3e;"' : ''; ?>>
                                    <?php echo htmlspecialchars($fb['category_name']); ?>
                                </strong>
                            </td>
                            <td><?php echo $fb['total_templates']; ?></td>
                            <td>
                                <?php if ($fb['unused_count'] > 0): ?>
                                    <span class="badge badge-info"><?php echo $fb['unused_count']; ?></span>
                                <?php else: ?>
                                    <span class="badge" style="background: #e53e3e; color: white;"><?php echo $fb['unused_count']; ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div style="width: 100%; min-width: 120px;">
                                    <div style="width: 100%; background: #edf2f7; height: 8px; border-radius: 4px; overflow: hidden; margin-bottom: 5px;">
                                        <div style="width: <?php echo $pct; ?>%; background: linear-gradient(90deg, #4fd1c5, #38b2ac); height: 100%;"></div>
                                    </div>
                                    <small><?php echo $pct; ?>% Used</small>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div style="margin-top: 25px; text-align: center;">
            <a href="boards.php" class="btn-submit" style="text-decoration: none; font-size: 0.9em;"><i class="fas fa-plus-circle"></i> Manage Templates</a>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
