<?php
require_once __DIR__ . '/../config/db.php';
$pdo = getDBConnection();
$message = ''; $messageType = '';

// Handle stage update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_stage'])) {
    try {
        $pdo->prepare("UPDATE stages SET name = ?, old_day = ?, total_pins_perDay = ?, number_pins = ?, number_aff_pins = ? WHERE id = ?")
            ->execute([trim($_POST['name']), (int)$_POST['old_day'], (int)$_POST['total_pins_perDay'], (int)$_POST['number_pins'], (int)$_POST['number_aff_pins'], (int)$_POST['stage_id']]);
        $message = "Stage updated successfully!"; $messageType = "success";
    } catch (PDOException $e) { $message = "Error: " . $e->getMessage(); $messageType = "error"; }
}

// Handle stage addition
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_stage'])) {
    try {
        $pdo->prepare("INSERT INTO stages (name, old_day, total_pins_perDay, number_pins, number_aff_pins) VALUES (?, ?, ?, ?, ?)")
            ->execute([trim($_POST['name']), (int)$_POST['old_day'], (int)$_POST['total_pins_perDay'], (int)$_POST['number_pins'], (int)$_POST['number_aff_pins']]);
        $message = "New stage added successfully!"; $messageType = "success";
    } catch (PDOException $e) { $message = "Error: " . $e->getMessage(); $messageType = "error"; }
}

// Handle stage deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_stage'])) {
    try {
        $pdo->prepare("DELETE FROM stages WHERE id = ?")->execute([(int)$_POST['stage_id']]);
        $message = "Stage deleted successfully!"; $messageType = "success";
    } catch (PDOException $e) { $message = "Error: " . $e->getMessage(); $messageType = "error"; }
}

$stages = $pdo->query("SELECT * FROM stages ORDER BY old_day ASC")->fetchAll();

$page_title = 'Posting Stages - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <h1><i class="fas fa-cog"></i> Posting Stages Configuration</h1>
</div>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $messageType; ?>"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<div class="page-card" style="border-left: 5px solid var(--primary);">
    <h2><i class="fas fa-plus-circle"></i> Add New Stage</h2>
    <form method="POST" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin-top: 15px;">
        <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Stage Name</label><input type="text" name="name" placeholder="e.g. Stage 4" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
        <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Min Age (days)</label><input type="number" name="old_day" value="0" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
        <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Total Pins/Day</label><input type="number" name="total_pins_perDay" value="10" min="1" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
        <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Reg Pins</label><input type="number" name="number_pins" value="8" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
        <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Aff Pins</label><input type="number" name="number_aff_pins" value="2" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
        <button type="submit" name="add_stage" class="btn-submit" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); color: white; border: none; border-radius: 5px; cursor: pointer; height: 38px; align-self: flex-end; font-weight: bold;">Create Stage</button>
    </form>
</div>

<h2 style="margin: 30px 0 20px 0; color: #2d3748;"><i class="fas fa-layer-group"></i> Existing Stages</h2>

<?php if (empty($stages)): ?>
    <div class="page-card" style="text-align: center; color: #999; padding: 50px;">
        No stages configured yet. Use the form above to add your first stage.
    </div>
<?php else: ?>
    <?php foreach ($stages as $stage): ?>
        <div class="page-card">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h3><?php echo htmlspecialchars($stage['name']); ?></h3>
                <form method="POST" onsubmit="return confirm('Are you sure you want to delete this stage?');" style="margin: 0;">
                    <input type="hidden" name="stage_id" value="<?php echo $stage['id']; ?>">
                    <button type="submit" name="delete_stage" style="background: none; border: none; color: #e53e3e; cursor: pointer; font-size: 1.1em;" title="Delete Stage">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                </form>
            </div>
            <form method="POST" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin-top: 15px;">
                <input type="hidden" name="stage_id" value="<?php echo $stage['id']; ?>">
                <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Name</label><input type="text" name="name" value="<?php echo htmlspecialchars($stage['name']); ?>" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
                <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Min Age (days)</label><input type="number" name="old_day" value="<?php echo $stage['old_day']; ?>" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
                <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Total Pins/Day</label><input type="number" name="total_pins_perDay" value="<?php echo $stage['total_pins_perDay']; ?>" min="1" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
                <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Reg Pins</label><input type="number" name="number_pins" value="<?php echo $stage['number_pins']; ?>" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
                <div style="display: flex; flex-direction: column;"><label style="font-size: 0.8em; color: #666;">Aff Pins</label><input type="number" name="number_aff_pins" value="<?php echo $stage['number_aff_pins']; ?>" min="0" required style="padding: 8px; border: 1px solid #e0e0e0; border-radius: 5px;"></div>
                <button type="submit" name="update_stage" class="btn-submit" style="background: var(--primary); color: white; border: none; border-radius: 5px; cursor: pointer; height: 38px; align-self: flex-end;">Update</button>
            </form>
        </div>
    <?php endforeach; ?>
<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>
