<?php
require_once __DIR__ . '/../config/db.php';

// Pagination and filters (keeping existing logic)
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$perPage = 20;
$offset = ($page - 1) * $perPage;
$status = isset($_GET['status']) ? $_GET['status'] : 'all';
$category = isset($_GET['category']) ? (int)$_GET['category'] : 0;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

$pdo = getDBConnection();
$where = [];
$params = [];
if ($status === 'unposted') $where[] = "p.pin_id IS NULL";
elseif ($status === 'posted') $where[] = "p.pin_id IS NOT NULL";
if ($category > 0) { $where[] = "p.category_id = :category"; $params['category'] = $category; }
if ($search) { $where[] = "(p.title LIKE :search OR p.description LIKE :search)"; $params['search'] = "%$search%"; }
$whereClause = !empty($where) ? "WHERE " . implode(" AND ", $where) : "";

$countSql = "SELECT COUNT(*) as total FROM pins p $whereClause";
$countStmt = $pdo->prepare($countSql);
$countStmt->execute($params);
$totalPins = $countStmt->fetch()['total'];
$totalPages = ceil($totalPins / $perPage);

$sql = "SELECT p.*, c.category_name FROM pins p LEFT JOIN categories c ON p.category_id = c.id $whereClause ORDER BY p.id DESC LIMIT :limit OFFSET :offset";
$stmt = $pdo->prepare($sql);
foreach ($params as $key => $value) $stmt->bindValue(":$key", $value);
$stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$pins = $stmt->fetchAll();

$categories = $pdo->query("SELECT id, category_name FROM categories ORDER BY category_name")->fetchAll();

$page_title = 'Manage Pins - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <h1>📋 Manage Pins</h1>
</div>

<div class="page-card">
    <form method="GET" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
        <input type="text" name="search" placeholder="Search title or description..." value="<?php echo htmlspecialchars($search); ?>" style="padding: 10px; border: 1px solid #e0e0e0; border-radius: 8px;">
        <select name="status" style="padding: 10px; border: 1px solid #e0e0e0; border-radius: 8px;">
            <option value="all" <?php echo $status === 'all' ? 'selected' : ''; ?>>All Status</option>
            <option value="unposted" <?php echo $status === 'unposted' ? 'selected' : ''; ?>>Unposted</option>
            <option value="posted" <?php echo $status === 'posted' ? 'selected' : ''; ?>>Posted</option>
        </select>
        <select name="category" style="padding: 10px; border: 1px solid #e0e0e0; border-radius: 8px;">
            <option value="0">All Categories</option>
            <?php foreach ($categories as $cat): ?>
                <option value="<?php echo $cat['id']; ?>" <?php echo $category == $cat['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($cat['category_name']); ?></option>
            <?php endforeach; ?>
        </select>
        <button type="submit" class="btn-submit" style="background: var(--primary); color: white; border: none; border-radius: 8px; cursor: pointer;">Filter</button>
    </form>

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="background: #f8f9fa;">
                    <th style="padding: 15px; text-align: left; border-bottom: 2px solid #e0e0e0;">Image</th>
                    <th style="padding: 15px; text-align: left; border-bottom: 2px solid #e0e0e0;">Title</th>
                    <th style="padding: 15px; text-align: left; border-bottom: 2px solid #e0e0e0;">Category</th>
                    <th style="padding: 15px; text-align: left; border-bottom: 2px solid #e0e0e0;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pins as $pin): ?>
                    <tr style="border-bottom: 1px solid #f0f0f0;">
                        <td style="padding: 15px;">
                            <?php if ($pin['pin_id']): ?>
                                <a href="https://www.pinterest.com/pin/<?php echo urlencode($pin['pin_id']); ?>" target="_blank">
                                    <img src="<?php echo htmlspecialchars($pin['imagelink']); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;" alt="Pin Image">
                                </a>
                            <?php else: ?>
                                <img src="<?php echo htmlspecialchars($pin['imagelink']); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;" alt="Pin Image">
                            <?php endif; ?>
                        </td>
                        <td style="padding: 15px;">
                            <strong>
                                <?php if ($pin['pin_id']): ?>
                                    <a href="https://www.pinterest.com/pin/<?php echo urlencode($pin['pin_id']); ?>" target="_blank" style="text-decoration: none; color: var(--primary); hover: underline;">
                                        <?php echo htmlspecialchars($pin['title']); ?>
                                    </a>
                                <?php else: ?>
                                    <?php echo htmlspecialchars($pin['title']); ?>
                                <?php endif; ?>
                            </strong>
                        </td>
                        <td style="padding: 15px;"><?php echo htmlspecialchars($pin['category_name']); ?></td>
                        <td style="padding: 15px;"><span style="padding: 5px 10px; border-radius: 20px; font-size: 0.8em; background: <?php echo $pin['pin_id'] ? '#d4edda; color: #155724;' : '#fff3cd; color: #856404;'; ?>"><?php echo $pin['pin_id'] ? 'Posted' : 'Unposted'; ?></span></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination simplified for space -->
    <div style="display: flex; justify-content: center; gap: 10px; margin-top: 20px;">
        <?php if ($page > 1): ?><a href="?page=<?php echo $page-1; ?>&status=<?php echo $status; ?>&category=<?php echo $category; ?>&search=<?php echo urlencode($search); ?>" style="padding: 8px 15px; background: #eee; border-radius: 5px; text-decoration: none; color: black;">Prev</a><?php endif; ?>
        <span style="padding: 8px 15px;">Page <?php echo $page; ?> of <?php echo $totalPages; ?></span>
        <?php if ($page < $totalPages): ?><a href="?page=<?php echo $page+1; ?>&status=<?php echo $status; ?>&category=<?php echo $category; ?>&search=<?php echo urlencode($search); ?>" style="padding: 8px 15px; background: #eee; border-radius: 5px; text-decoration: none; color: black;">Next</a><?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
