<?php
require_once __DIR__ . '/../config/db.php';
$pdo = getDBConnection();
$message = ''; $messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_delete'])) {
    $type = $_POST['bulk_delete'];
    try {
        if ($type === 'all') {
            $pdo->exec("DELETE FROM pins");
            $message = "All pins have been deleted successfully."; $messageType = "success";
        } elseif ($type === 'unposted') {
            $pdo->exec("DELETE FROM pins WHERE pin_id IS NULL");
            $message = "All unposted pins have been deleted."; $messageType = "success";
        } elseif ($type === 'posted') {
            $pdo->exec("DELETE FROM pins WHERE pin_id IS NOT NULL");
            $message = "All posted pins have been deleted."; $messageType = "success";
        }
    } catch (PDOException $e) {
        $message = "Database error: " . $e->getMessage(); $messageType = "error";
    }
}

$page_title = 'Dashboard - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <div>
        <h1 id="greeting">Dashboard</h1>
        <p class="welcome-text">Overview of your pinterest network</p>
    </div>
    <div id="date" style="color: #718096; font-weight: 500;"></div>
</div>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $messageType; ?>"><?php echo $message; ?></div>
<?php endif; ?>

<div class="stats-grid">
    <div class="stat-card">
        <i class="fas fa-thumbtack stat-icon"></i>
        <div class="stat-value" id="total-pins">0</div>
        <div class="stat-label">Total Pins</div>
        <form method="POST" onsubmit="return confirm('CRITICAL: Are you sure you want to delete ALL pins in the database? This cannot be undone.')" style="margin-top: 15px;">
            <input type="hidden" name="bulk_delete" value="all">
            <button type="submit" style="background: rgba(229, 62, 62, 0.1); color: #e53e3e; border: 1px solid rgba(229, 62, 62, 0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75em; cursor: pointer; transition: all 0.2s;">
                <i class="fas fa-trash-alt"></i> Delete All
            </button>
        </form>
    </div>
    
    <div class="stat-card">
        <i class="fas fa-clock stat-icon"></i>
        <div class="stat-value" id="unposted-pins">0</div>
        <div class="stat-label">Unposted</div>
        <form method="POST" onsubmit="return confirm('Are you sure you want to delete all UNPOSTED pins?')" style="margin-top: 15px;">
            <input type="hidden" name="bulk_delete" value="unposted">
            <button type="submit" style="background: rgba(229, 62, 62, 0.1); color: #e53e3e; border: 1px solid rgba(229, 62, 62, 0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75em; cursor: pointer; transition: all 0.2s;">
                <i class="fas fa-trash-alt"></i> Delete Unposted
            </button>
        </form>
    </div>
    
    <div class="stat-card">
        <i class="fas fa-check-circle stat-icon"></i>
        <div class="stat-value" id="posted-pins">0</div>
        <div class="stat-label">Posted</div>
        <form method="POST" onsubmit="return confirm('Are you sure you want to delete all POSTED pins?')" style="margin-top: 15px;">
            <input type="hidden" name="bulk_delete" value="posted">
            <button type="submit" style="background: rgba(229, 62, 62, 0.1); color: #e53e3e; border: 1px solid rgba(229, 62, 62, 0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75em; cursor: pointer; transition: all 0.2s;">
                <i class="fas fa-trash-alt"></i> Delete Posted
            </button>
        </form>
    </div>
    
    <div class="stat-card">
        <i class="fas fa-folder stat-icon"></i>
        <div class="stat-value" id="total-categories">0</div>
        <div class="stat-label">Categories</div>
        <div style="margin-top: 15px; height: 26px;"></div> <!-- Spacer to match other cards -->
    </div>
</div>

<h2 style="margin-bottom: 25px; color: #4a5568;"><i class="fas fa-bolt"></i> Quick Actions</h2>
<div class="actions-grid">
    <a href="upload_csv.php" class="action-card">
        <div class="card-icon"><i class="fas fa-file-upload"></i></div>
        <h3>Import Pins</h3>
        <p>Bulk import pins from CSV files with auto-category detection.</p>
    </a>
    
    <a href="pins_list.php" class="action-card">
        <div class="card-icon"><i class="fas fa-images"></i></div>
        <h3>Manage Library</h3>
        <p>View, edit, and filter your entire pin collection.</p>
    </a>
    
    <a href="stages.php" class="action-card">
        <div class="card-icon"><i class="fas fa-cog"></i></div>
        <h3>Posting Rules</h3>
        <p>Configure bot stages and automation performance.</p>
    </a>
</div>

<div class="api-section">
    <h2 style="margin-bottom: 20px; color: #4a5568;"><i class="fas fa-network-wired"></i> Developer Integration</h2>
    <p style="color: #718096; margin-bottom: 20px;">Use these endpoints to connect your posting automation bot.</p>
    
    <div class="api-endpoint">
        <div style="font-weight: 700; color: #2d3748; margin-bottom: 5px;">Fetch Random Pin</div>
        <code>GET /api/get_pin_api.php?acc_username=acc1&account_date=<?php echo date('Y-m-d'); ?></code>
    </div>
    
    <div class="api-endpoint">
        <div style="font-weight: 700; color: #2d3748; margin-bottom: 5px;">Mark Pin as Posted</div>
        <code>GET /api/api_edit.php?id=123&pin_id=PIN123&acc_username=acc1&bord_id=99887766</code>
    </div>
</div>

<script>
    // Set date
    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const dateElement = document.getElementById('date');
    if (dateElement) dateElement.textContent = new Date().toLocaleDateString('en-US', options);

    // Personalized greeting
    const hour = new Date().getHours();
    let greeting = 'Good Morning';
    if (hour >= 12) greeting = 'Good Afternoon';
    if (hour >= 18) greeting = 'Good Evening';
    const greetingElement = document.getElementById('greeting');
    if (greetingElement) greetingElement.textContent = greeting + ", " + "<?php echo htmlspecialchars($_SESSION['username'] ?? 'Admin'); ?>";

    // Load stats
    async function loadStats() {
        try {
            const response = await fetch('api_stats.php');
            const data = await response.json();
            
            if (data.success) {
                document.getElementById('total-pins').textContent = data.stats.total_pins;
                document.getElementById('unposted-pins').textContent = data.stats.unposted_pins;
                document.getElementById('posted-pins').textContent = data.stats.posted_pins;
                document.getElementById('total-categories').textContent = data.stats.total_categories;
            }
        } catch (error) {
            console.error('Error loading stats:', error);
        }
    }
    
    loadStats();
</script>

<?php require_once 'includes/footer.php'; ?>
