<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../auth_check.php';

$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Pinterest Pin Manager'; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #667eea;
            --secondary: #764ba2;
            --bg-color: #f4f7fa;
            --text-color: #333;
            --sidebar-width: 260px;
            --transition: all 0.3s ease;
            --shadow: 0 5px 20px rgba(0,0,0,0.05);
            --card-radius: 15px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: var(--sidebar-width);
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            padding: 20px;
            display: flex;
            flex-direction: column;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            box-shadow: 4px 0 15px rgba(0,0,0,0.1);
            z-index: 1000;
        }

        .brand {
            font-size: 1.5em;
            font-weight: bold;
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 40px;
            padding: 10px;
            color: white;
            text-decoration: none;
        }

        .nav-links {
            list-style: none;
            flex: 1;
        }

        .nav-links li {
            margin-bottom: 10px;
        }

        .nav-links a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 12px 15px;
            border-radius: 10px;
            transition: var(--transition);
            font-weight: 500;
        }

        .nav-links a:hover, .nav-links a.active {
            background: rgba(255,255,255,0.2);
            color: white;
            transform: translateX(5px);
        }

        .user-info {
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.2);
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        
        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            padding: 30px;
            background: #f8f9fe;
            width: calc(100% - var(--sidebar-width));
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }

        .header-content h1 {
            font-size: 2em;
            color: #2d3748;
        }

        /* Generic Card Style */
        .page-card {
            background: white;
            padding: 30px;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
            margin-bottom: 30px;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
            transition: transform 0.3s ease;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }
        
        .stat-card:hover { transform: translateY(-5px); }

        .stat-value {
            font-size: 2.5em;
            font-weight: 700;
            color: var(--primary);
            margin: 10px 0;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .stat-icon {
            font-size: 2em;
            margin-bottom: 10px;
            color: var(--primary);
            opacity: 0.8;
        }

        /* Actions Grid */
        .actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
        }
        
        .action-card {
            background: white;
            padding: 30px;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
            text-decoration: none;
            color: inherit;
            border: 1px solid transparent;
            display: flex;
            flex-direction: column;
            height: 100%;
        }
        
        .action-card:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
            box-shadow: 0 15px 30px rgba(102, 126, 234, 0.1);
        }
        
        .card-icon {
            font-size: 2.5em;
            color: var(--primary);
            margin-bottom: 20px;
            background: rgba(102, 126, 234, 0.1);
            width: 70px;
            height: 70px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .action-card h3 { font-size: 1.4em; margin-bottom: 10px; color: #2d3748; }
        .action-card p { color: #718096; flex: 1; }

        /* API Section */
        .api-section {
            background: white;
            padding: 30px;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
            margin-top: 40px;
        }

        .api-endpoint {
            background: #f7fafc;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 15px;
            border-left: 4px solid var(--primary);
            overflow-x: auto;
        }

        /* Tables */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #4a5568;
            border-bottom: 2px solid #edf2f7;
            background: #f8f9fa;
        }

        td {
            padding: 15px;
            border-bottom: 1px solid #edf2f7;
            color: #2d3748;
        }

        tr:hover { background: #f7fafc; }

        /* Forms */
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; color: #4a5568; }
        .form-control {
            width: 100%;
            padding: 12px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 1em;
            transition: var(--transition);
        }
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
            display: inline-block;
            text-align: center;
        }
        .btn-submit:hover { transform: translateY(-2px); }

        /* Alerts */
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .alert-success { background: #e6fffa; color: #2c7a7b; border: 1px solid #b2f5ea; }
        .alert-error { background: #fff5f5; color: #c53030; border: 1px solid #fed7d7; }

        /* Badges */
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.85em;
            font-weight: 500;
        }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-warning { background: #fff3cd; color: #856404; }
        .badge-info { background: #e7f3ff; color: #0066cc; }

        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
                padding: 15px 10px;
            }
            .sidebar .brand span, .sidebar .nav-links a span, .sidebar .user-info {
                display: none;
            }
            .main-content {
                margin-left: 70px;
                width: calc(100% - 70px);
            }
            .nav-links a {
                justify-content: center;
                padding: 12px 0;
            }
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <a href="index.php" class="brand">
            <i class="fab fa-pinterest"></i> <span>PinManager</span>
        </a>
        <ul class="nav-links">
            <li><a href="index.php" class="<?php echo $current_page == 'index.php' ? 'active' : ''; ?>"><i class="fas fa-home"></i> <span>Dashboard</span></a></li>
            <li><a href="upload_csv.php" class="<?php echo $current_page == 'upload_csv.php' ? 'active' : ''; ?>"><i class="fas fa-file-upload"></i> <span>Upload CSV</span></a></li>
            <li><a href="pins_list.php" class="<?php echo $current_page == 'pins_list.php' ? 'active' : ''; ?>"><i class="fas fa-list"></i> <span>Manage Pins</span></a></li>
            <li><a href="categories.php" class="<?php echo $current_page == 'categories.php' ? 'active' : ''; ?>"><i class="fas fa-tags"></i> <span>Categories</span></a></li>
            <li><a href="boards.php" class="<?php echo $current_page == 'boards.php' ? 'active' : ''; ?>"><i class="fas fa-columns"></i> <span>Boards</span></a></li>
            <li><a href="stages.php" class="<?php echo $current_page == 'stages.php' ? 'active' : ''; ?>"><i class="fas fa-layer-group"></i> <span>Posting Stages</span></a></li>
            <li><a href="accounts.php" class="<?php echo $current_page == 'accounts.php' ? 'active' : ''; ?>"><i class="fas fa-user-circle"></i> <span>Accounts</span></a></li>
            <li><a href="stats.php" class="<?php echo $current_page == 'stats.php' ? 'active' : ''; ?>"><i class="fas fa-chart-line"></i> <span>Statistics</span></a></li>
            <li style="margin-top: auto;"><a href="change_password.php" class="<?php echo $current_page == 'change_password.php' ? 'active' : ''; ?>"><i class="fas fa-key"></i> <span>Change Password</span></a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a></li>
        </ul>
        <div class="user-info">
            <small>Logged in as:</small>
            <strong><?php echo htmlspecialchars($_SESSION['username'] ?? 'Admin'); ?></strong>
        </div>
    </div>

    <div class="main-content">
