<?php
// admin/change_password.php
require_once '../config/db.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (session_status() === PHP_SESSION_NONE) session_start();
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = "All fields are required";
    } elseif ($new_password !== $confirm_password) {
        $error = "New passwords do not match";
    } elseif (strlen($new_password) < 6) {
        $error = "Password must be at least 6 characters long";
    } else {
        $pdo = getDBConnection();
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user_pass = $stmt->fetchColumn();
        
        if (password_verify($current_password, $user_pass)) {
            $new_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $update = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            if ($update->execute([$new_hash, $_SESSION['user_id']])) {
                $message = "Password updated successfully";
            } else {
                $error = "Failed to update password";
            }
        } else {
            $error = "Current password is incorrect";
        }
    }
}

$page_title = 'Change Password - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <h1>Change Password</h1>
    <p style="color: #718096">Update your account security credentials</p>
</div>

<div class="page-card" style="max-width: 600px;">
    <?php if ($message): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 500; color: #4a5568;">Current Password</label>
            <input type="password" name="current_password" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 8px;" required>
        </div>

        <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 500; color: #4a5568;">New Password</label>
            <input type="password" name="new_password" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 8px;" required minlength="6">
        </div>

        <div class="form-group" style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 500; color: #4a5568;">Confirm New Password</label>
            <input type="password" name="confirm_password" class="form-control" style="width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 8px;" required minlength="6">
        </div>

        <button type="submit" class="btn-submit" style="background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%); color: white; border: none; padding: 12px 25px; border-radius: 8px; font-weight: bold; cursor: pointer;">Update Password</button>
    </form>
</div>

<?php require_once 'includes/footer.php'; ?>
