<?php
require_once __DIR__ . '/../config/db.php';
$pdo = getDBConnection();
$message = ''; $messageType = '';

// Handle add category
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_category'])) {
    $categoryName = trim($_POST['category_name']);
    if (!empty($categoryName)) {
        try {
            $pdo->prepare("INSERT INTO categories (category_name) VALUES (:name)")->execute(['name' => $categoryName]);
            $message = "Category added successfully!"; $messageType = "success";
        } catch (PDOException $e) {
            $message = ($e->getCode() == 23000) ? "Category already exists!" : "Error adding category: " . $e->getMessage();
            $messageType = "error";
        }
    }
}

// Handle delete category
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_category'])) {
    $categoryId = (int)$_POST['category_id'];
    try {
        // Check if category is used in pins or boards
        $pinCount = $pdo->prepare("SELECT COUNT(*) FROM pins WHERE category_id = ?");
        $pinCount->execute([$categoryId]);
        $boardCount = $pdo->prepare("SELECT COUNT(*) FROM board_data WHERE category_id = ?");
        $boardCount->execute([$categoryId]);
        
        if ($pinCount->fetchColumn() > 0 || $boardCount->fetchColumn() > 0) {
            $message = "Cannot delete category: It is currently assigned to pins or board templates.";
            $messageType = "error";
        } else {
            $pdo->prepare("DELETE FROM categories WHERE id = ?")->execute([$categoryId]);
            $message = "Category deleted successfully!"; $messageType = "success";
        }
    } catch (PDOException $e) {
        $message = "Error deleting category: " . $e->getMessage();
        $messageType = "error";
    }
}

$categories = $pdo->query("SELECT c.*, COUNT(p.id) as total_pins FROM categories c LEFT JOIN pins p ON c.id = p.category_id GROUP BY c.id ORDER BY c.category_name")->fetchAll();

$page_title = 'Categories - Pinterest Pin Manager';
require_once 'includes/header.php';
?>

<div class="header-content">
    <h1>🏷️ Categories</h1>
</div>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $messageType; ?>"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<div class="page-card">
    <h2>Add New Category</h2>
    <form method="POST" style="display: flex; gap: 15px; margin-top: 15px;">
        <input type="text" name="category_name" placeholder="Enter category name..." required style="flex: 1; padding: 12px; border: 1px solid #e0e0e0; border-radius: 8px;">
        <button type="submit" name="add_category" class="btn-submit" style="background: var(--primary); color: white; border: none; border-radius: 8px; padding: 0 25px; cursor: pointer;">Add Category</button>
    </form>
</div>

<div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px;">
    <?php foreach ($categories as $category): ?>
        <div class="page-card" style="margin-bottom: 0; position: relative;">
            <form method="POST" onsubmit="return confirm('Are you sure you want to delete this category?');" style="position: absolute; top: 15px; right: 15px;">
                <input type="hidden" name="category_id" value="<?php echo $category['id']; ?>">
                <button type="submit" name="delete_category" style="background: none; border: none; color: #e53e3e; cursor: pointer; font-size: 1.1em;" title="Delete Category">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </form>
            <div style="font-size: 2.5em; margin-bottom: 15px;">📂</div>
            <h3 style="margin-bottom: 10px;"><?php echo htmlspecialchars($category['category_name']); ?></h3>
            <div style="border-top: 1px solid #f0f0f0; padding-top: 10px; color: #666;">
                <strong><?php echo $category['total_pins']; ?></strong> pins total
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php require_once 'includes/footer.php'; ?>
