<?php
/**
 * Statistics API
 * Returns dashboard statistics
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../config/db.php';

try {
    $pdo = getDBConnection();
    
    // Get total pins
    $totalPinsStmt = $pdo->query("SELECT COUNT(*) as count FROM pins");
    $totalPins = $totalPinsStmt->fetch()['count'];
    
    // Get unposted pins
    $unpostedStmt = $pdo->query("SELECT COUNT(*) as count FROM pins WHERE pin_id IS NULL");
    $unpostedPins = $unpostedStmt->fetch()['count'];
    
    // Get posted pins
    $postedStmt = $pdo->query("SELECT COUNT(*) as count FROM pins WHERE pin_id IS NOT NULL");
    $postedPins = $postedStmt->fetch()['count'];
    
    // Get total categories
    $categoriesStmt = $pdo->query("SELECT COUNT(*) as count FROM categories");
    $totalCategories = $categoriesStmt->fetch()['count'];
    
    // Get total boards
    $boardsStmt = $pdo->query("SELECT COUNT(*) as count FROM board_data");
    $totalBoards = $boardsStmt->fetch()['count'];
    
    // Get total account boards
    $accountBoardsStmt = $pdo->query("SELECT COUNT(*) as count FROM account_board");
    $totalAccountBoards = $accountBoardsStmt->fetch()['count'];
    
    echo json_encode([
        'success' => true,
        'stats' => [
            'total_pins' => (int)$totalPins,
            'unposted_pins' => (int)$unpostedPins,
            'posted_pins' => (int)$postedPins,
            'total_categories' => (int)$totalCategories,
            'total_boards' => (int)$totalBoards,
            'total_account_boards' => (int)$totalAccountBoards
        ]
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    error_log("Stats API Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Failed to load statistics'
    ]);
}
