<?php
require_once __DIR__ . '/../config/db.php';
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    die(json_encode(['success' => false, 'error' => 'Unauthorized']));
}

$type = $_POST['type'] ?? ''; // 'pins' or 'boards'
$offset = (int)($_POST['offset'] ?? 0);
$limit = (int)($_POST['limit'] ?? 100);
$filename = $_POST['filename'] ?? '';

$filepath = __DIR__ . '/../import/temp_' . basename($filename);

if (!file_exists($filepath)) {
    die(json_encode(['success' => false, 'error' => 'Temporary file not found']));
}

$pdo = getDBConnection();
$handle = fopen($filepath, 'r');
$imported = 0;
$skipped = 0;
$line = 0;

// Seek to the correct line
fgetcsv($handle); // Skip header if at start
for ($i = 0; $i < $offset; $i++) {
    if (fgetcsv($handle) === false) break;
}

try {
    $pdo->beginTransaction();
    
    while ($imported < $limit && ($data = fgetcsv($handle)) !== false) {
        if ($type === 'pins') {
            if (count($data) < 6) { $skipped++; continue; }
            $title = trim($data[0]);
            $desc = trim($data[1]);
            $img = trim($data[2]);
            $post = trim($data[3]);
            $futer = (int)$data[4];
            $cat = ucwords(strtolower(trim($data[5])));
            
            if (empty($title) || empty($img) || empty($cat)) { $skipped++; continue; }
            
            // Get/Create category for Pins
            $stmt = $pdo->prepare("SELECT id FROM categories WHERE category_name = ?");
            $stmt->execute([$cat]);
            $catId = $stmt->fetchColumn();
            
            if (!$catId) {
                $ins = $pdo->prepare("INSERT INTO categories (category_name) VALUES (?)");
                $ins->execute([$cat]);
                $catId = $pdo->lastInsertId();
            }
            
            // Insert Pin
            $ins = $pdo->prepare("INSERT INTO pins (title, description, imagelink, postlink, futerimg, category_id, inserted_date) VALUES (?, ?, ?, ?, ?, ?, NOW())");
            $ins->execute([$title, $desc, $img, $post, $futer, $catId]);
            $imported++;

        } elseif ($type === 'boards') {
            if (count($data) < 3) { $skipped++; continue; }
            $name = trim($data[0]);
            $desc = trim($data[1]);
            $cat = trim($data[2]);
            
            if (empty($name) || empty($cat)) { $skipped++; continue; }
            
            // Get/Create category for Boards
            $stmt = $pdo->prepare("SELECT id FROM categories WHERE category_name = ?");
            $stmt->execute([$cat]);
            $catId = $stmt->fetchColumn();
            
            if (!$catId) {
                $ins = $pdo->prepare("INSERT INTO categories (category_name) VALUES (?)");
                $ins->execute([$cat]);
                $catId = $pdo->lastInsertId();
            }
            
            // Insert Board
            $ins = $pdo->prepare("INSERT INTO board_data (name, description, category_id) VALUES (?, ?, ?)");
            $ins->execute([$name, $desc, $catId]);
            $imported++;
        }
    }
    
    $pdo->commit();
    fclose($handle);
    
    // Check if EOF
    $handle = fopen($filepath, 'r');
    for($i = 0; $i <= $offset + $imported; $i++) fgetcsv($handle);
    $is_done = (fgetcsv($handle) === false);
    fclose($handle);
    
    // If done, delete temporary file
    if ($is_done) {
        unlink($filepath);
    }
    
    echo json_encode([
        'success' => true, 
        'imported' => $imported, 
        'skipped' => $skipped,
        'done' => $is_done,
        'next_offset' => $offset + $imported + $skipped
    ]);

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
